/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.io.Serializable;
import jclass.table3.Run;

class ChainUtil
implements Serializable {
    Run[] runs = new Run[0];
    int last_pos;
    int last_run;

    ChainUtil(int n) {
        if (n > 0) {
            this.runs = ChainUtil.makeRuns(1);
            this.runs[0].value = -999;
            this.runs[0].end = n - 1;
        }
    }

    ChainUtil(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.append(nArray[n]);
            ++n;
        }
    }

    ChainUtil() {
    }

    private void resetCache() {
        this.last_run = 0;
        this.last_pos = 0;
    }

    private int RunLeftOfStart(Run[] runArray, int n, int n2) {
        if (runArray[n].start == n2) {
            return n - 1;
        }
        return n;
    }

    private int RunRightOfEnd(Run[] runArray, int n, int n2) {
        if (runArray[n].end == n2) {
            return n + 1;
        }
        return n;
    }

    private static final void copy(Run[] runArray, Run[] runArray2, int n, int n2, int n3) {
        int n4 = Math.min(runArray2.length - n2, runArray.length - n);
        n4 = Math.min(n4, n3);
        int n5 = 0;
        while (n5 < n4) {
            runArray[n5 + n].copy(runArray2[n5 + n2]);
            ++n5;
        }
    }

    private static final Run[] makeRuns(int n) {
        Run[] runArray = new Run[n];
        if (runArray != null) {
            int n2 = 0;
            while (n2 < n) {
                runArray[n2] = new Run();
                ++n2;
            }
        }
        return runArray;
    }

    private int getArrayPos(int n) {
        int n2 = 0;
        int n3 = this.runs.length - 1;
        int n4 = (n3 + n2) / 2;
        while (n3 >= n2) {
            n4 = (n3 + n2) / 2;
            if (n < this.runs[n4].start) {
                n3 = n4 - 1;
                continue;
            }
            if (n <= this.runs[n4].end) break;
            n2 = n4 + 1;
        }
        this.last_pos = n;
        this.last_run = n4;
        return n4;
    }

    private int fetchIndex(int n) {
        if (this.last_run >= this.runs.length) {
            return this.getArrayPos(n);
        }
        if (n == this.last_pos) {
            return this.last_run;
        }
        if (n <= this.runs[this.last_run].end && n >= this.runs[this.last_run].start) {
            this.last_pos = n;
            return this.last_run;
        }
        if (n == this.last_pos - 1) {
            --this.last_pos;
            return --this.last_run;
        }
        if (n == this.last_pos + 1) {
            ++this.last_pos;
            return ++this.last_run;
        }
        if (n >= this.runs[this.runs.length - 1].start) {
            this.last_pos = n;
            this.last_run = this.runs.length - 1;
            return this.last_run;
        }
        if (n <= this.runs[0].end) {
            this.last_pos = n;
            this.last_run = 0;
            return 0;
        }
        return this.getArrayPos(n);
    }

    private static final int SumBeforeRun(Run[] runArray, int n) {
        if (n > 0) {
            return runArray[n - 1].sum + runArray[n - 1].value * (runArray[n - 1].end - runArray[n - 1].start + 1);
        }
        return 0;
    }

    private static final int SumAtRun(Run[] runArray, int n) {
        if (n >= 0) {
            return runArray[n].sum + runArray[n].value * (runArray[n].end - runArray[n].start + 1);
        }
        return 0;
    }

    private static final int SumAtPos(Run[] runArray, int n, int n2) {
        if (n >= 0) {
            return runArray[n].sum + runArray[n].value * (n2 - runArray[n].start + 1);
        }
        return 0;
    }

    private static final void PropagateSum(Run[] runArray, int n, int n2, int n3) {
        int n4 = Math.min(n2, runArray.length - n);
        int n5 = 0;
        while (n5 < n4) {
            runArray[n5 + n].sum += n3;
            ++n5;
        }
    }

    private static final void ShuffleUp(Run[] runArray, int n, int n2, int n3, int n4) {
        int n5 = Math.min(n2, runArray.length - n);
        int n6 = 0;
        while (n6 < n5) {
            runArray[n6 + n].start -= n4;
            runArray[n6 + n].end -= n4;
            runArray[n6 + n].sum -= n3;
            ++n6;
        }
    }

    private static final void ShuffleDown(Run[] runArray, int n, int n2, int n3, int n4) {
        ChainUtil.ShuffleUp(runArray, n, n2, -n3, -n4);
    }

    private void ShuffleDownFromPos(Run[] runArray, int n, int n2, int n3, int n4, int n5) {
        if (runArray == null) {
            return;
        }
        if (runArray[n].start == n5) {
            ChainUtil.ShuffleDown(runArray, n, n2, n3, n4);
            return;
        }
        runArray[n].end += n4;
        if (n2 - 1 > 0) {
            ChainUtil.ShuffleDown(runArray, n + 1, n2 - 1, n3, n4);
        }
    }

    private static final int CalcDifference(Run[] runArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        if (n4 == n5) {
            n6 += (n3 - runArray[n4].value) * (n2 - n + 1);
        } else {
            n6 += (n3 - runArray[n4].value) * (runArray[n4].end - n + 1);
            int n7 = n4 + 1;
            while (n7 < n5) {
                n6 += (n3 - runArray[n7].value) * (runArray[n7].end - runArray[n7].start + 1);
                ++n7;
            }
            n6 += (n3 - runArray[n5].value) * (n2 - runArray[n5].start + 1);
        }
        return n6;
    }

    protected Object clone() {
        ChainUtil chainUtil = new ChainUtil();
        if (this.runs != null && this.runs.length != 0) {
            chainUtil.runs = ChainUtil.makeRuns(this.runs.length);
            ChainUtil.copy(chainUtil.runs, this.runs, 0, 0, this.runs.length);
            chainUtil.resetCache();
        }
        return chainUtil;
    }

    private static final boolean BlocksMerge(ChainUtil chainUtil, int n, int n2) {
        return n >= 0 && n2 < chainUtil.runs.length && chainUtil.runs[n].value == chainUtil.runs[n2].value;
    }

    private static final int GetNumNewRuns(ChainUtil chainUtil, boolean bl, int n, int n2) {
        if (bl) {
            return chainUtil.runs.length - (n2 - n);
        }
        return chainUtil.runs.length - (n2 - n - 1);
    }

    void delete(int n, int n2) {
        this.delete(n, n2, null);
    }

    void delete(int n, int n2, ChainUtil chainUtil) {
        int n3;
        if (this.runs == null || this.runs.length == 0) {
            return;
        }
        int n4 = this.runs.length - 1;
        if (n < 0 || n > this.runs[n4].end) {
            return;
        }
        if (n2 < 0 || n2 > this.runs[n4].end) {
            return;
        }
        if (n2 < n) {
            return;
        }
        if (n == 0 && n2 == this.runs[n4].end) {
            if (chainUtil != null) {
                chainUtil.runs = this.runs;
                chainUtil.resetCache();
            }
            this.runs = null;
            this.last_pos = 0;
            this.last_run = 0;
            return;
        }
        int n5 = this.fetchIndex(n);
        int n6 = this.RunLeftOfStart(this.runs, n5, n);
        int n7 = this.fetchIndex(n2);
        int n8 = this.RunRightOfEnd(this.runs, n7, n2);
        this.resetCache();
        int n9 = n2 - n + 1;
        int n10 = -1 * ChainUtil.CalcDifference(this.runs, n, n2, 0, n5, n7);
        boolean bl = ChainUtil.BlocksMerge(this, n6, n8);
        int n11 = ChainUtil.GetNumNewRuns(this, bl, n6, n8);
        if (chainUtil != null && (n3 = n7 - n5 + 1) > 0) {
            chainUtil.runs = ChainUtil.makeRuns(n3);
            Run[] runArray = chainUtil.runs;
            ChainUtil.copy(runArray, this.runs, 0, n5, n3);
            runArray[0].sum += runArray[0].value * (n - runArray[0].start);
            runArray[0].start = n;
            runArray[n3 - 1].end = n2;
            ChainUtil.ShuffleUp(runArray, 0, n3, runArray[0].sum, n);
        }
        if (bl) {
            this.runs[n6].end = this.runs[n8].end - n9;
        } else {
            if (n6 >= 0) {
                this.runs[n6].end = n - 1;
            }
            if (n8 < this.runs.length) {
                this.runs[n8].start = n;
                this.runs[n8].end -= n9;
                int n12 = this.runs[n8].sum = n6 >= 0 ? ChainUtil.SumAtRun(this.runs, n6) : 0;
            }
        }
        if (n8 + 1 < this.runs.length) {
            ChainUtil.ShuffleUp(this.runs, n8 + 1, this.runs.length - (n8 + 1), n10, n9);
        }
        if (n11 != this.runs.length) {
            Run[] runArray = ChainUtil.makeRuns(n11);
            int n13 = n6 + 1;
            ChainUtil.copy(runArray, this.runs, 0, 0, n13);
            if (bl) {
                ChainUtil.copy(runArray, this.runs, n13, n8 + 1, this.runs.length - (n8 + 1));
            } else {
                ChainUtil.copy(runArray, this.runs, n13, n8, this.runs.length - n8);
            }
            this.runs = runArray;
        }
    }

    private static final boolean INSERT_LEFT_MERGE(ChainUtil chainUtil, ChainUtil chainUtil2, int n) {
        return n >= 0 && chainUtil.runs[n].value == chainUtil2.runs[0].value;
    }

    private static final boolean INSERT_RIGHT_MERGE(ChainUtil chainUtil, ChainUtil chainUtil2, int n) {
        return n < chainUtil.runs.length && chainUtil.runs[n].value == chainUtil2.runs[chainUtil2.runs.length - 1].value;
    }

    private static final int getNumNewRunsForInsert(ChainUtil chainUtil, ChainUtil chainUtil2, boolean bl, boolean bl2, int n, int n2) {
        return chainUtil.runs.length + chainUtil2.runs.length - (bl ? 1 : 0) - (bl2 ? 1 : 0) + (n2 < chainUtil.runs.length && n != chainUtil.runs[n2].start ? 1 : 0);
    }

    void insert(ChainUtil chainUtil, int n) {
        if (this.runs == null || this.runs.length == 0) {
            return;
        }
        int n2 = this.runs.length - 1;
        if (chainUtil == null || chainUtil.runs == null || chainUtil.runs.length == 0) {
            return;
        }
        Run[] runArray = chainUtil.runs;
        int n3 = chainUtil.runs.length - 1;
        if (n < 0 || n > this.runs[this.runs.length - 1].end + 1) {
            return;
        }
        int n4 = n == 0 ? -1 : this.fetchIndex(n - 1);
        int n5 = n > this.runs[n2].end ? n2 + 1 : this.fetchIndex(n);
        this.resetCache();
        if (n4 >= 0 && n < this.runs[n4].start) {
            return;
        }
        boolean bl = ChainUtil.INSERT_LEFT_MERGE(this, chainUtil, n4);
        boolean bl2 = ChainUtil.INSERT_RIGHT_MERGE(this, chainUtil, n5);
        int n6 = ChainUtil.getNumNewRunsForInsert(this, chainUtil, bl, bl2, n, n5);
        if (n5 < this.runs.length) {
            this.ShuffleDownFromPos(this.runs, n5, this.runs.length - n5, ChainUtil.SumAtRun(runArray, n3), runArray[n3].end + 1, n);
        }
        ChainUtil.ShuffleDown(runArray, 0, chainUtil.runs.length, ChainUtil.SumAtPos(this.runs, n4, n - 1), n);
        if (bl) {
            runArray[0].start = this.runs[n4].start;
            runArray[0].sum = this.runs[n4].sum;
        }
        if (bl2) {
            runArray[n3].end = this.runs[n5].end;
        }
        if (n6 == this.runs.length) {
            if (bl) {
                this.runs[n4].end = runArray[0].end;
            }
            if (bl2) {
                this.runs[n5].start = runArray[n3].start;
                this.runs[n5].sum = ChainUtil.SumBeforeRun(this.runs, n5);
                return;
            }
        } else {
            int n7;
            Run[] runArray2 = ChainUtil.makeRuns(n6);
            ChainUtil.copy(runArray2, this.runs, 0, 0, n4 + 1);
            if (bl) {
                ChainUtil.copy(runArray2, runArray, n4, 0, chainUtil.runs.length);
                n7 = n4 + chainUtil.runs.length - 1;
            } else {
                if (n4 >= 0) {
                    runArray2[n4].end = n - 1;
                }
                ChainUtil.copy(runArray2, runArray, n4 + 1, 0, chainUtil.runs.length);
                n7 = n4 + chainUtil.runs.length;
            }
            if (bl2) {
                ChainUtil.copy(runArray2, this.runs, n7 + 1, n5 + 1, this.runs.length - (n5 + 1));
            } else if (n7 + 1 < n6) {
                ChainUtil.copy(runArray2, this.runs, n7 + 1, n5, this.runs.length - n5);
                runArray2[n7 + 1].sum = ChainUtil.SumBeforeRun(runArray2, n7 + 1);
                runArray2[n7 + 1].start = runArray[n3].end + 1;
            }
            this.runs = runArray2;
        }
    }

    void move(int n, int n2, int n3) {
        ChainUtil chainUtil = new ChainUtil();
        n3 -= n3 > n ? n2 : 0;
        ChainUtil chainUtil2 = (ChainUtil)this.clone();
        try {
            this.delete(n, n + n2 - 1, chainUtil);
            this.insert(chainUtil, n3);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.runs = chainUtil2.runs;
            return;
        }
    }

    void append(int n) {
        if (this.runs == null || this.runs.length == 0) {
            this.runs = ChainUtil.makeRuns(1);
            this.runs[0].sum = 0;
            this.runs[0].end = 0;
            this.runs[0].start = 0;
            this.runs[0].value = n;
            return;
        }
        if (this.runs[this.runs.length - 1].value != n) {
            int n2 = this.runs.length - 1;
            int n3 = this.runs.length;
            Run[] runArray = ChainUtil.makeRuns(this.runs.length + 1);
            ChainUtil.copy(runArray, this.runs, 0, 0, this.runs.length);
            runArray[n3].start = runArray[n3].end = runArray[n2].end + 1;
            runArray[n3].value = n;
            runArray[n3].sum = ChainUtil.SumBeforeRun(runArray, n3);
            this.runs = runArray;
            this.last_run = n3;
            return;
        }
        ++this.runs[this.last_run].end;
    }

    int getRunLen(int n) {
        int n2 = this.fetchIndex(n);
        if (n2 < 0 || n2 >= this.runs.length) {
            this.resetCache();
            return -1;
        }
        return this.runs[n2].value;
    }

    int getRunSum(int n) {
        int n2;
        int n3 = this.fetchIndex(n);
        if (n3 < 0) {
            this.resetCache();
            n2 = -1;
        } else {
            n2 = n3 >= 0 && n3 < this.runs.length && n <= this.runs[n3].end ? this.runs[n3].sum + this.runs[n3].value * (n - this.runs[n3].start) : 0;
        }
        return n2;
    }

    private static final int getNumNewRunsForSet(ChainUtil chainUtil, boolean bl, boolean bl2, int n, int n2) {
        return chainUtil.runs.length - (n2 - n) + (bl ? 0 : 1) + (bl2 ? 0 : 1);
    }

    private static final boolean setLeftMerge(ChainUtil chainUtil, int n, int n2) {
        return n2 >= 0 && n == chainUtil.runs[n2].value;
    }

    private static final boolean setRightMerge(ChainUtil chainUtil, int n, int n2) {
        return n2 < chainUtil.runs.length && n == chainUtil.runs[n2].value;
    }

    void setRunLen(int n, int n2, int n3) {
        int n4;
        if (this.runs == null || this.runs.length == 0) {
            return;
        }
        int n5 = this.runs.length - 1;
        int n6 = this.fetchIndex(n);
        int n7 = this.RunLeftOfStart(this.runs, n6, n);
        int n8 = this.fetchIndex(n2);
        int n9 = this.RunRightOfEnd(this.runs, n8, n2);
        this.resetCache();
        boolean bl = ChainUtil.setLeftMerge(this, n3, n7);
        boolean bl2 = ChainUtil.setRightMerge(this, n3, n9);
        int n10 = ChainUtil.getNumNewRunsForSet(this, bl, bl2, n7, n9);
        int n11 = ChainUtil.CalcDifference(this.runs, n, n2, n3, n6, n8);
        if (n9 + 1 < this.runs.length) {
            ChainUtil.PropagateSum(this.runs, n9 + 1, this.runs.length - (n9 + 1), n11);
        }
        if (n10 == this.runs.length) {
            if (n7 >= 0) {
                if (!bl) {
                    this.runs[n7].end = n - 1;
                    this.runs[n7 + 1].start = n;
                    this.runs[n7 + 1].value = n3;
                    this.runs[n7 + 1].sum = ChainUtil.SumBeforeRun(this.runs, n7 + 1);
                }
            } else {
                this.runs[0].value = n3;
            }
            if (n9 < this.runs.length) {
                if (!bl2) {
                    this.runs[n9 - 1].end = n2;
                    this.runs[n9].start = n2 + 1;
                    this.runs[n9].sum = ChainUtil.SumBeforeRun(this.runs, n9);
                    return;
                }
            } else {
                this.runs[this.runs.length - 1].value = n3;
            }
            return;
        }
        Run[] runArray = ChainUtil.makeRuns(n10);
        ChainUtil.copy(runArray, this.runs, 0, 0, n7 + 1);
        if (bl) {
            n4 = n7;
        } else {
            if (n7 >= 0) {
                runArray[n7].end = n - 1;
            }
            runArray[n7 + 1].start = n;
            runArray[n7 + 1].sum = ChainUtil.SumBeforeRun(runArray, n7 + 1);
            runArray[n7 + 1].value = n3;
            n4 = n7 + 1;
        }
        if (bl2) {
            runArray[n4].end = this.runs[n9].end;
            ChainUtil.copy(runArray, this.runs, n4 + 1, n9 + 1, this.runs.length - (n9 + 1));
        } else {
            runArray[n4].end = n2;
            if (n9 < this.runs.length) {
                runArray[n4 + 1] = this.runs[n9];
                runArray[n4 + 1].start = n2 + 1;
                runArray[n4 + 1].sum = ChainUtil.SumBeforeRun(runArray, n4 + 1);
                ChainUtil.copy(runArray, this.runs, n4 + 2, n9 + 1, this.runs.length - (n9 + 1));
            }
        }
        this.runs = runArray;
    }

    int[] getArray() {
        if (this.runs == null) {
            return null;
        }
        int[] nArray = new int[this.runs[this.runs.length - 1].end];
        int n = 0;
        while (n < this.runs.length) {
            int n2 = this.runs[n].start;
            while (n2 <= this.runs[n].end) {
                nArray[n2] = this.runs[n].value;
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public int getValueAtPosition(int n) {
        int n2 = 0;
        while (n2 < this.runs.length) {
            if (this.runs[n2].sum > n) break;
            ++n2;
        }
        if (--n2 == -1) {
            return -999;
        }
        return (n - this.runs[n2].sum) / this.runs[n2].value + this.runs[n2].start;
    }
}

